# Executive

Other names for a chatbot executive:

- Autonomous agent
- AI agent
- Intelligent agent
- Agent
- Dialog engine executor

---
# Executive in the human brain?

- Free will
- Prefrontal cortex
- Personality

# Executive higher level thinking?

- Consciousness
- Theory of mind

??? notes
If a chatbot has a conscious awareness of itself and it's intents, then the executive would have to be the part of the code that would use that self-awareness to make decisions.
And if a chatbot has a model of human behavior, called a "theory of mind", then this model would help the executive predict the impact of what it says so it can plan the dialog to achieve it's goal or objective function.

---
# What is a Chatbot Executive?

Decides what to say next.
The exective is equivalent to the "will" or prefrontal cortex in a human.
An executive needs an objective function or a goal.

---
# Executive Objective Function or Goal

Select response with ...
- max confidence score from generator
- max confidence score from executive
- closest semantics to goal
- closest sentiment to goal

---
# Dialog Planning

- Path planning problem like map navigation
- Nodes are human statements + context (state of the world)
- Edges are bot statements/actions
- Goal node is user saying "Thank you" or nothing, etc.

---
# Architecture

![Hybrid chatbot architecture](./Hybrid%20Chatbot%20Architecture.svg)

---
# Architecture

<img src="./Hybrid Chatbot Architecture.svg">

---
# Datasets

- [MLMastery NLP Datasets](https://machinelearningmastery.com/datasets-natural-language-processing/)
- [LionBridge Chatbot Datasets](https://lionbridge.ai/datasets/15-best-chatbot-datasets-for-machine-learning/)
- [Enron E-mails](https://www.cs.cmu.edu/~enron/)
- [Your Android Text Messages](https://blog.jay2k1.com/2014/11/10/how-to-export-and-backup-your-google-hangouts-chat-history/)
- [Academic Dialog Datasets](https://breakend.github.io/DialogDatasets/)

---
# Noncommercial Use Datasets

- [Yahoo NLP Data](https://webscope.sandbox.yahoo.com/catalog.php?datatype=l&guccounter=1) (QA, etc)

---
# Chatbot Frameworks

- [Will](https://github.com/skoczen/will)
- [Chatterbot](https://github.com/gunthercox/ChatterBot)
- [AIChat](http://aira.github.io/aichat)
- [AirBNB Slack Plugin? Chat frontend?]()
